VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmMain 
   Caption         =   "USBDO96 Demonstrator"
   ClientHeight    =   5145
   ClientLeft      =   165
   ClientTop       =   855
   ClientWidth     =   8055
   LinkTopic       =   "Form1"
   ScaleHeight     =   5145
   ScaleWidth      =   8055
   StartUpPosition =   3  'Windows Default
   WhatsThisHelp   =   -1  'True
   Begin VB.TextBox txtComPort 
      Enabled         =   0   'False
      Height          =   285
      Left            =   1800
      TabIndex        =   19
      Text            =   "1"
      Top             =   240
      Width           =   255
   End
   Begin VB.TextBox txtRelayPos 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   360
      TabIndex        =   8
      Top             =   3000
      Width           =   735
   End
   Begin VB.TextBox txtBankPos 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   360
      TabIndex        =   7
      Top             =   2520
      Width           =   735
   End
   Begin VB.OptionButton opRecycleOff 
      Caption         =   "RecycleOff"
      Height          =   255
      Left            =   360
      TabIndex        =   6
      Top             =   1560
      Width           =   1095
   End
   Begin VB.OptionButton opRecycleOn 
      Caption         =   "RecycleOn"
      Height          =   255
      Left            =   360
      TabIndex        =   5
      Top             =   1080
      Width           =   1095
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   375
      Left            =   360
      TabIndex        =   4
      Top             =   3360
      Width           =   1095
   End
   Begin VB.VScrollBar vsbStepInt 
      Height          =   2295
      LargeChange     =   10
      Left            =   3240
      Max             =   2000
      Min             =   10
      SmallChange     =   10
      TabIndex        =   2
      Top             =   1200
      Value           =   500
      Width           =   255
   End
   Begin VB.TextBox txtTimerVal 
      Alignment       =   1  'Right Justify
      Enabled         =   0   'False
      Height          =   315
      Left            =   2280
      TabIndex        =   0
      Text            =   "20"
      Top             =   1200
      Width           =   735
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "Clear Relays"
      Height          =   495
      Left            =   3600
      TabIndex        =   10
      Top             =   4200
      Width           =   1095
   End
   Begin VB.TextBox txtRelay_num 
      Alignment       =   1  'Right Justify
      Height          =   435
      Left            =   5760
      TabIndex        =   9
      Text            =   "0"
      Top             =   1440
      Width           =   735
   End
   Begin VB.Timer tmrCmdDelay 
      Interval        =   10
      Left            =   7560
      Top             =   4080
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   6840
      Top             =   4440
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.CommandButton cmdOn 
      Caption         =   "Close"
      Height          =   375
      Left            =   4560
      TabIndex        =   1
      Top             =   1440
      Width           =   855
   End
   Begin VB.Timer tmrRlyOnOff 
      Interval        =   100
      Left            =   7560
      Top             =   4560
   End
   Begin VB.Frame frmIndRly 
      Caption         =   "Individual Relay Control"
      Height          =   3375
      Left            =   4200
      TabIndex        =   12
      Top             =   600
      Width           =   3495
      Begin VB.CommandButton cmdOff 
         Caption         =   "Open"
         Height          =   375
         Left            =   360
         TabIndex        =   18
         Top             =   1560
         Width           =   855
      End
      Begin VB.Label Label2 
         Caption         =   "Relay Number"
         Height          =   375
         Left            =   1560
         TabIndex        =   13
         Top             =   480
         Width           =   1335
      End
   End
   Begin VB.Frame frmRelayCycle 
      Caption         =   "Cycle Relays"
      Height          =   3375
      Left            =   120
      TabIndex        =   11
      Top             =   600
      Width           =   3735
      Begin VB.Label lblTimerInt 
         Caption         =   "Timer Interval (msecs)"
         Height          =   255
         Left            =   1920
         TabIndex        =   17
         Top             =   240
         Width           =   1695
      End
      Begin VB.Label lblRelayState 
         Height          =   255
         Left            =   240
         TabIndex        =   16
         Top             =   1560
         Width           =   1455
      End
      Begin VB.Label Label4 
         Caption         =   "Relay Number"
         Height          =   255
         Left            =   1080
         TabIndex        =   15
         Top             =   2400
         Width           =   1095
      End
      Begin VB.Label Label3 
         Caption         =   "Relay Bank"
         Height          =   255
         Left            =   1080
         TabIndex        =   14
         Top             =   1920
         Width           =   1095
      End
   End
   Begin VB.Label Label5 
      Caption         =   "Comm Port"
      Height          =   255
      Left            =   2280
      TabIndex        =   20
      Top             =   240
      Width           =   855
   End
   Begin VB.Label Label1 
      Caption         =   "Label1"
      Height          =   255
      Left            =   3600
      TabIndex        =   3
      Top             =   1440
      Width           =   15
   End
   Begin VB.Menu mnuFile 
      Caption         =   "F&ile"
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuComm 
      Caption         =   "CommPort"
      Begin VB.Menu mnuPort1 
         Caption         =   "Port&1"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuPort2 
         Caption         =   "Port&2"
      End
      Begin VB.Menu mnuPort3 
         Caption         =   "Port&3"
      End
      Begin VB.Menu mnuPort4 
         Caption         =   "Port&4"
      End
      Begin VB.Menu mnuPortSel 
         Caption         =   "Comm Port Select"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'USBDO96 Demonstrator
' Version 1.1
' Written by Philip Allen
' **************************************
Option Explicit

Dim guLowerRelay(6) As Byte
Dim guUpperRelay(6) As Byte
Dim gbPortNotReady As Boolean
Dim gbRecycleOn As Boolean
Dim gbRunning As Boolean
Dim gbScanComplete As Boolean
Dim gbCloseRelays As Boolean
Dim guRelayPos As Integer
Dim guBankPos As Byte

Private Sub CmdDelay(uVal As Integer)
    tmrCmdDelay.Interval = uVal
    
    tmrCmdDelay.Enabled = True
    gbPortNotReady = True
    
    While gbPortNotReady = True
        DoEvents
    Wend

End Sub

Private Function OpenCommPort(PortNum As Integer)
    Dim uRData(0) As Byte
    Dim Msg
    
On Error GoTo PortError

    If MSComm1.PortOpen = True Then
        MSComm1.PortOpen = False
    End If

    MSComm1.Settings = "9600,n,8,1"
    MSComm1.CommPort = PortNum
    MSComm1.PortOpen = True
    OpenCommPort = True
GoTo SubEnd

PortError:
    Msg = Err.Description
    MsgBox Msg, vbOKOnly
    
    ' Close port if open and set to default o 1
    If MSComm1.PortOpen = True Then
        MSComm1.PortOpen = False
    End If
    
    MSComm1.CommPort = 1
    OpenCommPort = False

SubEnd:

End Function
Private Sub SendCommand(cmd As String, Data() As Byte)
    MSComm1.Output = cmd
    MSComm1.Output = Data
    CmdDelay 10
    
End Sub
Private Sub SetPortStates(Dir As String)
   Dim uRData(0) As Byte
   
   If Dir = "INPUT" Then
       uRData(0) = 255
    Else
       uRData(0) = 0
    End If
      
    SendCommand "B", uRData  'Set B port
    CmdDelay 10

    SendCommand "E", uRData 'Set C port
    CmdDelay 10

    SendCommand "H", uRData 'Set D port
    CmdDelay 10

End Sub
Private Sub Initialise()

    Dim uRData(0) As Byte
    Dim i As Byte
    
    ' set Controls
    tmrRlyOnOff.Enabled = False
    opRecycleOff.Value = True
    opRecycleOn.Value = False
    
    ' Set all PIC ports to Outputs
    SetPortStates "OUTPUT"
    
    ClearRelays
        
    ' Enable all latches
    uRData(0) = CLK_LOW_OE_HIGH
    SendCommand "C", uRData  'Set Clock and all lines low
        
End Sub

Private Function ActivateRelay(ByVal uPosition As Integer, ByVal iBank As Byte, OnOff As Byte)
    Dim uRData(0) As Byte
    If uPosition <= 8 Then
        If OnOff = 1 Then
            guLowerRelay(iBank) = guLowerRelay(iBank) Or (2 ^ (uPosition - 1))
        Else
            guLowerRelay(iBank) = guLowerRelay(iBank) And (Not (2 ^ (uPosition - 1)))
        End If
        
    Else
        uPosition = uPosition - 8
        If OnOff = 1 Then
            guUpperRelay(iBank) = guUpperRelay(iBank) Or (2 ^ (uPosition - 1))
        Else
            guUpperRelay(iBank) = guUpperRelay(iBank) And (Not (2 ^ (uPosition - 1)))
        End If
    End If
        
    uRData(0) = guLowerRelay(iBank)
    SendCommand "F", uRData  'Set Relay 1 high
    uRData(0) = guUpperRelay(iBank)
    SendCommand "J", uRData  'Set Relay 1 high
       

End Function
Private Sub ActivateBank(ByVal uBank As Byte)
Dim BankWord As Byte
Dim uRData(0) As Byte
    ' This function relies upon initialisation to set all latch
    ' outputs low
    
    'Prepare BankWord
    BankWord = 2 ^ (uBank)
    
    uRData(0) = BankWord Or 1 'bank pos + OE High
    SendCommand "C", uRData
    
    'Return bank clock low for next access
    uRData(0) = 1 'Clock low OE still high
    SendCommand "C", uRData

End Sub

Private Sub ClearRelays()
    Dim i As Byte
    Dim uRData(0) As Byte
    
    ' Set Latch enable off
    uRData(0) = 0
    SendCommand "C", uRData
    
    'Clear Relay control words
    For i = 1 To 6
        guLowerRelay(i) = 0
        guUpperRelay(i) = 0
    Next i
    
    'set All relay lines low
    uRData(0) = 0
    SendCommand "F", uRData  'All lower port Relays Low
    SendCommand "J", uRData  'All upper port Relays Low
    
    'Set all latch ouputs low
    For i = 1 To 6
        uRData(0) = (2 ^ i)
        SendCommand "C", uRData
    
        'Return bank clock low for next access
        uRData(0) = 0
        SendCommand "C", uRData
    Next i
    
    ' Set Latch enable back to on
    uRData(0) = 1
    SendCommand "C", uRData
    
    'Set Global default states
    guRelayPos = 0
    guBankPos = 1
    gbRecycleOn = False
    gbCloseRelays = True
        
    ' Set text boxes
    txtRelayPos = guRelayPos
    txtBankPos = guBankPos


End Sub

Private Sub CloseRelay(ByVal RelNum As Integer, RelBank As Byte)

    ActivateRelay RelNum, RelBank, 1
    ActivateBank RelBank
    
End Sub
Private Sub OpenRelay(ByVal RelNum As Integer, RelBank As Byte)

    ActivateRelay RelNum, RelBank, 0
    ActivateBank RelBank
           
End Sub

Private Sub Scan_Relays()

    If guRelayPos < GIMAXRELAY Then
         guRelayPos = guRelayPos + 1
    Else
         guRelayPos = 1
         If guBankPos < GIMAXBANK Then
            guBankPos = guBankPos + 1
         Else
            guBankPos = 1
            guRelayPos = 1
            gbCloseRelays = False
         End If
    End If
        
    If gbCloseRelays = True Then
        lblRelayState.Caption = "Closing Relay:"
        CloseRelay guRelayPos, guBankPos
    Else
        lblRelayState.Caption = "Opening Relay:"
        OpenRelay guRelayPos, guBankPos
    End If
    
    ' Check if reached end of Scan for Closing
    If guBankPos = GIMAXBANK And guRelayPos >= GIMAXRELAY Then
        guBankPos = 5
        guRelayPos = 15
        
        If gbCloseRelays = True Then
            gbCloseRelays = False
        Else
            gbScanComplete = True
        guBankPos = 1
        guRelayPos = 0
        End If
    End If
    
    If gbCloseRelays = True And guBankPos > 1 Then
    
        OpenRelay guRelayPos, (guBankPos - 1)
    End If
    
    txtRelayPos = guRelayPos
    txtBankPos = guBankPos

End Sub

Private Sub EnableControls()
    cmdOff.Enabled = True
    cmdOn.Enabled = True
    cmdClear.Enabled = True
    cmdStart.Enabled = True
    Initialise
End Sub
Private Sub DisableControls()
    cmdOff.Enabled = False
    cmdOn.Enabled = False
    cmdClear.Enabled = False
    cmdStart.Enabled = False
End Sub
Private Sub cmdOff_Click()
    Dim RelayNum As Integer
    Dim BankNum As Byte
    
    If txtRelay_num.Text > 0 And txtRelay_num.Text <= 96 Then
        'Calculate Bank and Relay
        RelayNum = txtRelay_num.Text Mod GIMAXRELAY
        If RelayNum = 0 Then
            RelayNum = GIMAXRELAY
        End If
        
        BankNum = ((txtRelay_num.Text - 1) \ GIMAXRELAY) + 1

        OpenRelay RelayNum, BankNum
    Else
        MsgBox "Value out of range", vbCritical, "Range Error"
    End If
    
End Sub

Private Sub cmdOn_Click()
    Dim RelayNum As Integer
    Dim BankNum As Byte
    
    If txtRelay_num.Text > 0 And txtRelay_num.Text <= 96 Then
        'Calculate Bank and Relay
        RelayNum = txtRelay_num.Text Mod GIMAXRELAY
        If RelayNum = 0 Then
            RelayNum = GIMAXRELAY
        End If
        
        BankNum = ((txtRelay_num.Text - 1) \ GIMAXRELAY) + 1
                
        CloseRelay RelayNum, BankNum
    Else
        MsgBox "Value out of range", vbCritical, "Range Error"
    End If
        
        
        
End Sub

Private Sub cmdClear_Click()
    ClearRelays
End Sub

Private Sub cmdStart_Click()
    
    If cmdStart.Caption = "Start" Then
        cmdClear.Enabled = False
        cmdOn.Enabled = False
        cmdOff.Enabled = False
        cmdStart.Caption = "Stop"
        lblRelayState.Caption = "Closing Relay:"
        gbScanComplete = False
        tmrRlyOnOff.Enabled = True
    Else
        tmrRlyOnOff.Enabled = False
        cmdClear.Enabled = True
        cmdOn.Enabled = True
        cmdOff.Enabled = True
        cmdStart.Caption = "Start"
    End If
    
End Sub

Private Sub Form_Load()
    Dim uComPortNum As Integer
    Dim sComPorStr As String
    
    tmrRlyOnOff.Enabled = False
    DisableControls
           
    If MSComm1.PortOpen = True Then
        MSComm1.PortOpen = False
    End If
    
    vsbStepInt.Value = 500
    txtTimerVal.Text = vsbStepInt.Value
    tmrRlyOnOff.Interval = vsbStepInt.Value
    
    sComPorStr = InputBox("Enter Comm Port Value", "USBD096 Demonstrator", 1, , 800)
       
    If sComPorStr = "" Then
        uComPortNum = 1
    Else
        uComPortNum = Val(sComPorStr)
    End If
    
    If OpenCommPort(uComPortNum) Then
      EnableControls
        txtComPort.Text = uComPortNum
        Initialise
    Else
        DisableControls
    End If
    
End Sub


Private Sub mnuExit_Click()
    'Check if port is open before trying to clear
    If MSComm1.PortOpen = True Then
        ClearRelays
    End If
    
    End
End Sub

Private Sub mnuPort1_Click()
    mnuPort1.Checked = True
    mnuPort2.Checked = False
    mnuPort3.Checked = False
    mnuPort4.Checked = False
    
    If OpenCommPort(1) = True Then
        txtComPort.Text = 1
        EnableControls
    Else
        txtComPort.Text = 0
        DisableControls
    End If
End Sub

Private Sub mnuPort2_Click()
    mnuPort1.Checked = False
    mnuPort2.Checked = True
    mnuPort3.Checked = False
    mnuPort4.Checked = False
    
    If OpenCommPort(2) = True Then
        txtComPort.Text = 2
        EnableControls
    Else
        txtComPort.Text = 0
        DisableControls
    End If
    
End Sub

Private Sub mnuPort3_Click()
    mnuPort1.Checked = False
    mnuPort2.Checked = False
    mnuPort3.Checked = True
    mnuPort4.Checked = False
        
    If OpenCommPort(3) = True Then
        txtComPort.Text = 3
        EnableControls
    Else
        txtComPort.Text = 0
        DisableControls
    End If
End Sub

Private Sub mnuPort4_Click()
    mnuPort1.Checked = False
    mnuPort2.Checked = False
    mnuPort3.Checked = False
    mnuPort4.Checked = True
    
    If OpenCommPort(4) = True Then
        txtComPort.Text = 4
        EnableControls
    Else
        txtComPort.Text = 0
        DisableControls
    End If
End Sub

Private Sub mnuPortSel_Click()
Dim PortNum As Integer
Dim sComPorStr As String

    mnuPort1.Checked = False
    mnuPort2.Checked = False
    mnuPort3.Checked = False
    mnuPort4.Checked = False
    
    sComPorStr = InputBox("Enter Comm Port Value", "USBD096 Demonstrator", 1, , 800)
    
    If sComPorStr = "" Then
        PortNum = 0
    Else
        PortNum = Val(sComPorStr)
    End If
    
    If OpenCommPort(PortNum) = True Then
    
        txtComPort.Text = PortNum
        Select Case PortNum
        Case 1
             mnuPort1.Checked = True
        Case 2
             mnuPort2.Checked = True
        Case 3
             mnuPort3.Checked = True
        Case 4
             mnuPort4.Checked = True
        End Select
        EnableControls
    Else
        txtComPort.Text = 0
        DisableControls
    End If
End Sub

Private Sub opRecycleOff_Click()
    gbRecycleOn = False
End Sub

Private Sub opRecycleOn_Click()
    gbRecycleOn = True
End Sub

Private Sub tmrCmdDelay_Timer()
  gbPortNotReady = False
  tmrCmdDelay.Enabled = False
End Sub

Private Sub tmrRlyOnOff_Timer()
    
    Scan_Relays
    
    If gbScanComplete = True Then
        If gbRecycleOn = False Then
            tmrRlyOnOff.Enabled = False
            cmdStart.Caption = "Start"
            lblRelayState.Caption = ""
            cmdClear.Enabled = True
            cmdOn.Enabled = True
            cmdOff.Enabled = True
        Else
            gbScanComplete = False
            gbCloseRelays = True
        End If
    End If
    
    txtRelayPos = guRelayPos
    txtBankPos = guBankPos
    
End Sub

Private Sub vsbStepInt_Change()

txtTimerVal.Text = vsbStepInt.Value
tmrRlyOnOff.Interval = vsbStepInt.Value

End Sub

